function [u, v, a, t] = NISDOF(M, C, K, F, brojPodataka, dt, tipNumerickeInteracije)
%Numericka integracija - SDOF sistem
% M - masa
% C - prigusenje
% K - krutost
% F - vektor sila
% brojPodataka - broj vremenskih trenutaka za numericku integraciju
% dt - interval numericke integracije
% tipNumerickeInteracije:
%     Metoda centralnih razlika -> 1 (uslovno stabilan postupak: dt<=Tn/pi)
%     NEWMARK a=const -> 2 (bezuslovno stabilan postupak)
%     Duhamel - numericko resenje -> 3 (bezuslovno stabilan postupak; samo za relativno prigusenje manje od 1)

%Iskljucuje upozorenja u ovom fajlu...
%#ok<*NASGU>

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Pocetni uslovi
U=zeros(brojPodataka,1);
V=zeros(brojPodataka,1);
A=zeros(brojPodataka,1);
%Pocetno pomeranje
U(1,1)=0;
%Pocetna brzina
V(1,1)=0;
%Pocetno ubrzanje
A(1,1)=(1/M)*(F(1,1)-C*V(1,1)-K*U(1,1));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Priprema za numericku integraciju
%Promenljive za metodu centralnih razlika i Newmark-ov postupak (a=const.)
%koje se jednom odrede na po?etku
uzPomeranjePrethodno=0.0;
uzPomeranjeTrenutno=0.0;    
Kzam=0.0;
KzamInv=0.0;
Urfiktivno=0.0;
%Promenljive za numericko resenje Duhamel-ovog integrala
%koje se jednom odrede na po?etku
w=0.0;
relPrig=0.0;
wd=0.0;
Aa=0.0;
Bb=0.0;
Cc=0.0;
Dd=0.0;
Aaprim=0.0;
Bbprim=0.0;
Ccprim=0.0;
Ddprim=0.0;
%Priprema za metodu centralnih razlika
if tipNumerickeInteracije == 1
    uzPomeranjePrethodno=(1/dt^2)*M-(1/(2*dt))*C;
    uzPomeranjeTrenutno=K-(2/dt^2)*M;    
    Kzam=(1/dt^2)*M+(1/(2*dt))*C;
    KzamInv=Kzam^-1;
    Urfiktivno=U(1,1)-dt*V(1,1)+(dt^2/2)*A(1,1);
%Priprema za NEWMARK a=const
elseif tipNumerickeInteracije == 2    
    Kzam=K+(4/dt^2)*M+(2/dt)*C;
    KzamInv=Kzam^-1;
%Priprema za numericko resenje Duhamel-ovog integrala
elseif tipNumerickeInteracije == 3    
    w=sqrt(K/M);
    relPrig=C/(2*M*w);
    wd=w*sqrt(1-relPrig^2);
    Aa=exp(-relPrig*w*dt)*((relPrig/sqrt(1-relPrig^2))*sin(wd*dt)+cos(wd*dt));
    Bb=exp(-relPrig*w*dt)*((1/wd)*sin(wd*dt));
    Cc=(1/K)*(2*relPrig/(w*dt)+exp(-relPrig*w*dt)*(((1-2*relPrig^2)/(wd*dt)-relPrig/sqrt(1-relPrig^2))*sin(wd*dt)-(1+(2*relPrig)/(w*dt))*cos(wd*dt)));
    Dd=(1/K)*(1-(2*relPrig)/(w*dt)+exp(-relPrig*w*dt)*((((2*relPrig^2)-1)/(wd*dt))*sin(wd*dt)+((2*relPrig)/(w*dt))*cos(wd*dt)));
    Aprim=-exp(-relPrig*w*dt)*((w/sqrt(1-relPrig^2))*sin(wd*dt));
    Bprim=exp(-relPrig*w*dt)*(cos(wd*dt)-(relPrig/sqrt(1-relPrig^2))*sin(wd*dt));
    Cprim=(1/K)*(-(1/dt)+exp(-relPrig*w*dt)*((w/(sqrt(1-relPrig^2))+relPrig/(dt*sqrt(1-relPrig^2)))*sin(wd*dt)+(1/dt)*cos(wd*dt)));
    Dprim=(1/(K*dt))*(1-exp(-relPrig*w*dt)*((relPrig/sqrt(1-relPrig^2))*sin(wd*dt)+cos(wd*dt)));
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Numericka integracija
vektorVremenskihTrenutaka=zeros(brojPodataka,1);
for i = 1:1:(brojPodataka-1)
    %Metoda centralnih razlika
    if tipNumerickeInteracije == 1
        if i == 1
            Qkzam=F(i,1)-uzPomeranjePrethodno*Urfiktivno-...
                  uzPomeranjeTrenutno*U(i,1);
            U(i+1,1)=KzamInv*Qkzam;
            V(i,1)=(1/(2*dt))*(U(i+1,1)-Urfiktivno);
            A(i,1)=(1/dt^2)*(U(i+1,1)-2*U(i,1)+Urfiktivno);        
        else
            Qkzam=F(i,1)-uzPomeranjePrethodno*U(i-1,1)-...
                  uzPomeranjeTrenutno*U(i,1);
            U(i+1,1)=KzamInv*Qkzam;
            V(i,1)=(1/(2*dt))*(U(i+1,1)-U(i-1,1));
            A(i,1)=(1/dt^2)*(U(i+1)-2*U(i,1)+U(i-1,1));
        end
    %NEWMARK a=const
    elseif tipNumerickeInteracije == 2
        vektorZamenjujucegOpterecenja=F(i+1,1)-F(i,1)+...
                                      M*((4/dt)*V(i,1)+...
                                      2*A(i,1))+2*C*V(i,1);
        deltaUr=KzamInv*vektorZamenjujucegOpterecenja;
        U(i+1,1)=U(i,1)+deltaUr;
        V(i+1,1)=(2/dt)*deltaUr-V(i,1);
        A(i+1,1)=(4/dt^2)*(U(i+1,1))-...
                 (4/dt^2)*(U(i,1))-...
                 (4/dt)*(V(i,1))-A(i,1);
    %Duhamel - numericko resenje
    elseif tipNumerickeInteracije == 3
        U(i+1,1)=Aa*U(i,1)+Bb*V(i,1)+Cc*F(i,1)+Dd*F(i+1,1);
        V(i+1,1)=Aprim*U(i,1)+Bprim*V(i,1)+Cprim*F(i,1)+Dprim*F(i+1,1);
        A(i+1,1)=(1/M)*(F(i+1,1)-K*U(i+1,1)-C*V(i+1,1));
    end
    
    %Vremenski trenuci
    vektorVremenskihTrenutaka(i+1,1)=i*dt;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Povratne vrednosti
u=U;
v=V;
a=A;
t=vektorVremenskihTrenutaka;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%